% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{scale_quantile}
\alias{scale_quantile}
\title{Calculate and apply a quantile scale}
\usage{
scale_quantile(x, outlier_cutoff = 0.05)
}
\arguments{
\item{x}{A numeric vector, matrix or data frame.}

\item{outlier_cutoff}{The quantile cutoff for outliers (default 0.05).}
}
\value{
The centered, scaled matrix or vector. The numeric centering and scalings used are returned as attributes.
}
\description{
Calculate and apply a quantile scale
}
\examples{
## Generate a matrix from a normal distribution
## with a large standard deviation, centered at c(5, 5)
x <- matrix(rnorm(200*2, sd = 10, mean = 5), ncol = 2)

## Scale the dataset between [0,1]
x_scaled <- scale_quantile(x)

## Plot rescaled data
plot(x_scaled)

## Show ranges of each column
apply(x_scaled, 2, range)
}
