% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{prepare_geo}
\alias{prepare_geo}
\title{Download and Process GEO Data}
\usage{
prepare_geo(
  geo,
  dir = ".",
  combine = TRUE,
  method = "max",
  filter_regex = NULL
)
}
\arguments{
\item{geo}{A character string specifying the GEO Series ID (e.g., "GSE12345").}

\item{dir}{A character string specifying the directory where files should be downloaded. Default is the current working directory (\code{"."}).}

\item{combine}{A logical value indicating whether to combine multiple probes into a single gene symbol. Default is \code{TRUE}.}

\item{method}{A character string specifying the method to use for combining probes into a single gene symbol. Options are \code{"max"} (take the maximum value) or \code{"mean"} (compute the average). Default is \code{"max"}.}

\item{filter_regex}{A character string specifying a regular expression to filter the supplementary files for download. Default is \code{NULL}, which means no filtering is applied.}
}
\value{
A list containing:
\item{data}{A data frame of the expression matrix.}
\item{sample}{A data frame of the sample metadata.}
\item{feature}{A data frame of the feature metadata, which includes gene symbols if combining probes.}
}
\description{
This function downloads gene expression data from the Gene Expression Omnibus (GEO) database.
It retrieves either the expression matrix or the supplementary tabular data if the expression data is not available.
The function also allows for the conversion of probe identifiers to gene symbols and can combine multiple probes into a single symbol.
}
