% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isval.R
\name{isval}
\alias{isval}
\title{Is Valid / Is a Value / NA NULL Check}
\usage{
isval(x, na_strings = easyr::nastrings, do.test.each = FALSE)
}
\arguments{
\item{x}{Object to check. In the case of a tibble or vector, it will check the first (non-NULL) value.}

\item{na_strings}{(Optional) Set the strings you want to consider NA. These will be applied after stringr::str_trim on x.}

\item{do.test.each}{Return a vector of results to check each element instead of checking the entire object.}
}
\value{
True/false indicating if the argument is NA, NULL, or an empty/NA string/vector. For speect, only the first value is checked.
}
\description{
Facilitates checking for missing values which may cause errors later in code. 
NULL values can cause errors on is.na checks, and is.na can cause warnings if it is inside if() and is passed multiple values.
This function makes it easier to check for missing values before trying to operate on a variable. 
It will NOT check for strings like ""  or "NA". Only NULL and NA values will return TRUE.
Author: Bryce Chamberlain. Tech Review: Maria Gonzalez.
}
\examples{
isval( NULL )
isval( NA )
isval( c( NA , NULL ) )
isval( c( 1, 2, 3 ) )
isval( c( NA, 2, 3 ) )
isval( c( 1, 2, NA ) ) # only the first values is checked, so this will come back FALSE.
isval( c( NULL, 2, 3 ) ) # NULL values get skipped in a vector.
isval( data.frame() )
isval( dplyr::group_by( dplyr::select( cars, speed, dist ), speed ) ) # test a tibble.
isval( "#VALUE!" ) # test an excel error code.
}
