% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumnum.R
\name{sumnum}
\alias{sumnum}
\title{Summarize All Numeric Columns}
\usage{
sumnum(x, do.fun = NULL, except = c(), do.ungroup = TRUE, ...)
}
\arguments{
\item{x}{Data frame or tibble to summarize.}

\item{do.fun}{Function to use for the summary. Passed to dplyr::summarize(). Can be a custom function. Defaults to sum().}

\item{except}{Columns names, numbers, or a logical vector indicating columns NOT to summarize.}

\item{do.ungroup}{Run dplyr::ungroup() after summarizing the prevent future issues with grouping.}

\item{...}{Extra args passed to dplyr::summarize() which are applied as arguments to the function passed in do.fun.}
}
\value{
Summarized data frame or tibble.
}
\description{
Easily summarize at all numeric variables. Helpful for flexibly summarizing without knowing the columns. Defaults to sum but you can send a custom function through also. Typically pass in a data frame after group_by.
}
\examples{

require(dplyr)
require(easyr)

sumnum( group_by( cars, speed ) )
sumnum( group_by( cars, speed ), mean )
sumnum( cars )

}
