% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemsPerFormConstraint.R
\name{itemsPerFormConstraint}
\alias{itemsPerFormConstraint}
\title{Create number of items per test form constraints.}
\usage{
itemsPerFormConstraint(
  nForms,
  nItems = NULL,
  operator = c("<=", "=", ">="),
  targetValue,
  whichForms = seq_len(nForms),
  itemIDs = NULL
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool [optional to create \code{itemIDs} automatically].}

\item{operator}{A character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{The target value to be used in the constraints. That is,
the number of items per form.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Creates constraints related to the number of items in each test form.
}
\details{
The number of items per test form is constrained to be either
(a) smaller or equal than (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater or equal than
(\code{operator = ">="}) the chosen \code{value}.
}
\examples{
## Constrain the test forms to have exactly five items
itemsPerFormConstraint(3, operator = "=", targetValue = 5,
                       itemIDs = 1:20)

}
