% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useSolver.R
\name{useSolver}
\alias{useSolver}
\title{Use a solver for a list of constraints.}
\usage{
useSolver(
  allConstraints,
  solver = c("GLPK", "lpSolve", "Gurobi", "Symphony"),
  timeLimit = Inf,
  formNames = NULL,
  ...
)
}
\arguments{
\item{allConstraints}{List of constraints.}

\item{solver}{A character string indicating the solver to use.}

\item{timeLimit}{The maximal runtime in seconds.}

\item{formNames}{A character vector with names to give to the forms.}

\item{...}{Additional arguments for the solver.}
}
\value{
A list with the following elements:
\describe{
  \item{\code{solution_found}}{Was a solution found?}
  \item{\code{solution}}{Numeric vector containing the found solution.}
  \item{\code{solution_status}}{Was the solution optimal?}
}
}
\description{
Use a mathematical programming solver to solve a list for constrains.
}
\details{
Wrapper around the functions of different solvers (\code{gurobi::gurobi(),
lpSolve::lp(), ...} for a list of constraints set up via \code{eatATA}.
\code{Rglpk} is used per default.

Additional arguments can be passed through
\code{...} and vary from solver to solver (see their respective help pages,
\code{\link[lpSolve]{lp}} or \code{\link[Rglpk]{Rglpk_solve_LP}}); for example
time limits can not be set for \code{lpSolve}.
}
\examples{
nForms <- 2
nItems <- 4

# create constraits
target <- minimaxObjective(nForms = nForms, c(1, 0.5, 1.5, 2),
                       targetValue = 2, itemIDs = 1:nItems)
noItemOverlap <- itemUsageConstraint(nForms, operator = "=", itemIDs = 1:nItems)
testLength <- itemsPerFormConstraint(nForms = nForms,
                           operator = "<=", targetValue = 2, itemIDs = 1:nItems)

# use a solver
result <- useSolver(list(target, noItemOverlap, testLength),
  itemIDs = paste0("Item_", 1:4),
  solver = "GLPK")



}
