% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeBlockExclusion.R
\name{analyzeBlockExclusion}
\alias{analyzeBlockExclusion}
\title{Analyze block exclusiveness}
\usage{
analyzeBlockExclusion(processedObj, idCol, exclusionTuples)
}
\arguments{
\item{processedObj}{Object created by \code{gurobi} solver and processed by \code{\link{processGurobiOutput}}.
Must be a \code{list}.}

\item{idCol}{Column name with item IDs in the \code{data.frames} in \code{processedObj}.}

\item{exclusionTuples}{\code{data.frame} with two columns, containing tuples with item IDs which should be in test forms exclusively.
Must be the same object as used in \code{\link{itemExclusionConstraint}}.}
}
\value{
A \code{data.frame} of block exclusions.
}
\description{
Use exclusion tuples information to determine which assembled test blocks are exclusive.
}
\details{
If exclusion tuples have been used to assemble test forms (using the \code{\link{itemExclusionConstraint}} function), the resulting
item blocks might also be exclusive. Using the initially used item exclusion tuples and the processed \code{gurobi} output
(via \code{\link{processGurobiOutput}}) this function determines, which item blocks are exclusive and can not be together in an
assembled test form.
}
\examples{
## Full workflow using itemExclusionTuples
# Example data.frame
items <- data.frame(ID = c("items1", "items2", "items3", "items4"),
                     exclusions = c("items2, items3", NA, NA, NA))

# Create tuples
exTuples2 <- itemExclusionTuples(items = items, idCol = "ID", exclusions = "exclusions",
                    sepPattern = ", ")

#' ## Create constraints
exclusion_constraint <- itemExclusionConstraint(nForms = 2, exclusionTuples = exTuples2,
                                                itemIDs = items$ID)
depletion_constraint <- depletePoolConstraint(2, nItems = 4)
target_constraint <- itemTargetConstraint(nForms = 2, nItems = 4,
                                          itemValues = c(3, 1.5, 2, 4), targetValue = 1)

gurobi_model <- prepareConstraints(list(exclusion_constraint, target_constraint,
                                        depletion_constraint),
                                   nForms = 2, nItems = 4)

\dontrun{
# Run gurobi (this can only be run with Gurobi and the gurobi package installed,
# for which a Gurobi license is required)
gurobi_out <- gurobi::gurobi(gurobi_model, params = list(TimeLimit = 30))

processedObj <- processGurobiOutput(gurobi_out, items = items, nForms = 2, output = "list")

analyzeBlockExclusion(processedObj, exTuples2)
}

}
