% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processGurobiOutput.R
\name{processGurobiOutput}
\alias{processGurobiOutput}
\title{Process \code{gurobi} output}
\usage{
processGurobiOutput(gurobiObj, items, nForms, output = "data.frame")
}
\arguments{
\item{gurobiObj}{Object created by \code{gurobi} solver.}

\item{items}{Original \code{data.frame} containing information on item level.}

\item{nForms}{Number of forms that have been created.}

\item{output}{Should the output be returned as a \code{data.frame} or a \code{list}?}
}
\value{
a \code{data.frame} or a \code{list}.
}
\description{
Process a \code{gurobi} output of a successfully solved optimization problem so it becomes humanly readable.
}
\details{
The output can either be transformed to a \code{data.frame} (optimal for writing to disk and re-importing into other programs) or to
a \code{list} (optimal for quick visual inspection.)
}
\examples{
## using existing gurobi example
processGurobiOutput(gurobiExample, items = items, nForms = 2, output = "list")
processGurobiOutput(gurobiExample, items = items, nForms = 2, output = "data.frame")


## Full workflow
items <- data.frame(paste0("item", 1:10), stringsAsFactors = FALSE)
items$RTs <- c(5, 3, 4, 1, 2.5, 8.5, 6, 5, 4, 6.5)

# setup constraints
constraint1 <- depletePoolConstraint(2, nItems = 10)
constraint2 <- itemTargetConstraint(2, nItems = 10, itemValues = items$RTs, targetValue = 20)

gurobi_model <- prepareConstraints(list(constraint1, constraint2),
                                   nForms = 2, nItems = 10)

\dontrun{
# Run gurobi (this can only be run with Gurobi and the gurobi package installed,
# for which a Gurobi license is required)
gurobi_out <- gurobi::gurobi(gurobi_model, params = list(TimeLimit = 30))

processGurobiOutput(gurobi_out, items = items, nForms = 2, output = "list")
}

}
