% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeBlockExclusion.R
\name{analyzeBlockExclusion}
\alias{analyzeBlockExclusion}
\title{Analyze block exclusiveness}
\usage{
analyzeBlockExclusion(solverOut, items, idCol, exclusionTuples)
}
\arguments{
\item{solverOut}{Object created by \code{useSolver}.}

\item{items}{Original \code{data.frame} containing information on item level.}

\item{idCol}{Column name with item IDs in the \code{items} \code{data.frames}.}

\item{exclusionTuples}{\code{data.frame} with two columns, containing tuples with item IDs which should be in test
forms exclusively. Must be the same object as used in \code{\link{itemExclusionConstraint}}.}
}
\value{
A \code{data.frame} of block exclusions.
}
\description{
Use exclusion tuples information to determine which assembled test blocks are exclusive.
}
\details{
If exclusion tuples have been used to assemble test forms (using the \code{\link{itemExclusionConstraint}}
function), the resulting
item blocks might also be exclusive. Using the initially used item exclusion tuples and the optimal solution
given by \code{useSolver} this function determines, which item blocks are exclusive and can not be together in an
assembled test form.
}
\examples{
## Full workflow using itemExclusionTuples
# Example data.frame
items <- data.frame(ID = c("items1", "items2", "items3", "items4"),
                     exclusions = c("items2, items3", NA, NA, NA),
                     stringsAsFactors = FALSE)

# Create tuples
exTuples2 <- itemExclusionTuples(items = items, idCol = "ID", exclusions = "exclusions",
                    sepPattern = ", ")

#' ## Create constraints
exclusion_constraint <- itemExclusionConstraint(nForms = 2, exclusionTuples = exTuples2,
                                                itemIDs = items$ID)
depletion_constraint <- depletePoolConstraint(2, nItems = 4)
target_constraint <- itemTargetConstraint(nForms = 2, nItems = 4,
                                          itemValues = c(3, 1.5, 2, 4), targetValue = 1)

opt_solution <- useSolver(list(exclusion_constraint, target_constraint,
                                        depletion_constraint),
                                   nForms = 2, nItems = 4, itemIDs = items$ID)

analyzeBlockExclusion(opt_solution, items = items, idCol = "ID",
                       exclusionTuples = exTuples2)


}
