% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ebirdst_runs}
\alias{ebirdst_runs}
\title{Data frame of available eBird Status and Trends species}
\format{
A data frame with 107 rows and 14 variables:
\describe{
\item{species_code}{Six letter eBird code in eBird Taxonomy v2016}
\item{run_name}{Unique analysis identifier and the top level folder name
for all results}
\item{scientific_name}{Scientific name from eBird Taxonomy v2016}
\item{common_name}{English common name from eBird Taxonomy v2016}
\item{breeding_start_dt}{Breeding season start date}
\item{breeding_end_dt}{Breeding season start date}
\item{nonbreeding_start_dt}{Non-breeding season start date}
\item{nonbreeding_end_dt}{Non-breeding season start date}
\item{postbreeding_migration_start_dt}{Post-breeding season start date}
\item{postbreeding_migration_end_dt}{Post-breeding season start date}
\item{prebreeding_migration_start_dt}{Pre-breeding season start date}
\item{prebreeding_migration_end_dt}{Pre-breeding season start date}
\item{year_round_start_dt}{For resident species, the year-round start date}
\item{year_round_end_dt}{For resident species, the year-round end date}
}
}
\usage{
ebirdst_runs
}
\description{
A dataset containing the species for which eBird Status and Trends data are
available In addition, the dates defining the boundaries of the seasons are
provided. These seasons are defined on a species-specific basis through
expert review. For information on the details of defining seasons, please see
the \href{https://ebird.org/science/status-and-trends/faq#seasons}{seasons section of the FAQ}. Note that
missing dates imply that a season failed expert review for that species
within that season.
}
\keyword{datasets}
