% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_horseshoe}
\alias{ebnm_horseshoe}
\title{Solve the EBNM problem using horseshoe priors}
\usage{
ebnm_horseshoe(
  x,
  s = 1,
  scale = "estimate",
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  control = NULL
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A \emph{scalar} specifying the standard error of the observations
(observations must be homoskedastic).}

\item{scale}{A scalar corresponding to \eqn{s\tau} in the usual
parametrization of the \code{\link{horseshoe}} distribution, or
\code{"estimate"} if this parameter is to be estimated from the data.}

\item{g_init}{The prior distribution \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. When
supplied, \code{g_init} should be an object of class
\code{\link{horseshoe}} or an \code{ebnm} object in which the fitted
prior is an object of class \code{horseshoe}.}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{control}{A list of control parameters to be passed to function
\code{\link[stats]{optimize}}.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The function takes parameters
        \code{nsamp}, the number of posterior samples to return per
        observation, and \code{burn}, the number of burn-in samples to
        discard (an MCMC sampler is used).}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using the family of
  \link{horseshoe} distributions. Identical to function \code{\link{ebnm}}
  with argument \code{prior_family = "horseshoe"}. For details about the
  model, see \code{\link{ebnm}}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
