% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_resample.R
\name{ebv_resample}
\alias{ebv_resample}
\title{Change the resolution of the data of an EBV netCDF}
\usage{
ebv_resample(
  filepath_src,
  datacubepath_src = NULL,
  entity_src = NULL,
  timestep_src = 1,
  resolution,
  outputpath,
  method = "bilinear",
  scenario = NULL,
  metric = NULL,
  return_raster = FALSE,
  overwrite = FALSE,
  ignore_RAM = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filepath_src}{Character. Path to the netCDF file whose resolution
should be changed.}

\item{datacubepath_src}{Character. Optional. Default: NULL. Path to the
datacube (use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}). Alternatively, you can use
the scenario and metric argument to define which cube you want to access.}

\item{entity_src}{Character or Integer. Default is NULL. If the structure is
3D, the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs.}

\item{timestep_src}{Integer or character. Select one or several timestep(s).
Either provide an integer value or list of values that refer(s) to the
index of the timestep(s) (minimum value: 1) or provide a date or list of
dates in ISO format, such as '2015-01-01'.}

\item{resolution}{Character or Numeric. Either the path to an EBV netCDF file
that determines the resolution (character) or the resolution defined
directly (numeric). The vector defining the resolution directly must
contain three elements: the x-resolution, the y-resolution and the
corresponding EPSG code, e.g. c(0.25, 0.25, 4326).}

\item{outputpath}{Character. Set path to write data as GeoTiff on disk.}

\item{method}{Character. Default: bilinear. Define resampling method. Choose
from: "near","bilinear","cubic", "cubicspline", "lanczos", "sum", "min",
"q1", "med", "q3", "max", "average", "mode" and "rms". For categorical
data, use 'near'. Based on \code{\link[terra:project]{terra::project()}}.}

\item{scenario}{Character or integer. Optional. Default: NULL. Define the
scenario you want to access. If the EBV netCDF has no scenarios, leave the
default value (NULL). You can use an integer value defining the scenario or
give the name of the scenario as a character string. To check the available
scenarios and their name or number (integer), use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{metric}{Character or integer. Optional. Define the metric you want to
access. You can use an integer value defining the metric or give the name
of the scenario as a character string. To check the available metrics and
their name or number (integer), use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{return_raster}{Logical. Default: FALSE. Set to TRUE to directly get the
corresponding SpatRaster object.}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE to overwrite the output
file defined by 'outputpath'.}

\item{ignore_RAM}{Logical. Default: FALSE. Checks if there is enough space in
your memory to read the data. Can be switched off (set to TRUE).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Default: returns the output path of the GeoTiff with the new
resolution. Optional: return the SpatRaster object with the new resolution.
}
\description{
Change the resolution of one datacube of a EBV netCDF based on
another EBV netCDF or a given resolution.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"),
                    package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

#define different resolutions
res1 <- system.file(file.path("extdata",
        "baisero_spepop_id5_20220405_v1_empty.nc"), package="ebvcube")
res2 <- c(0.5,0.5,4326)
#define output path
out <- file.path(system.file(package='ebvcube'),"extdata","changeRes.tif")

\dontrun{
#resample defining the resolution and EPSG code by hand - return SpatRaster
data_raster <- ebv_resample(filepath_src = file, datacubepath_src = datacubes[1,1],
                            entity_src=1, timestep_src = 1, resolution = res2,
                            outputpath = out, method='near', return_raster=TRUE,
                            overwrite=TRUE)
#resample using a netCDF file - return GeoTiff
ebv_resample(filepath_src = file, datacubepath_src = datacubes[1,1],
             entity_src=1, timestep_src = 1, resolution = res1,
             outputpath = out, overwrite=TRUE)

}
}
