% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfHT.R
\name{ecdfHT.multivar}
\alias{ecdfHT.2d}
\alias{ecdfHT.2d.axes}
\alias{ecdfHT.multivar}
\alias{ecdfHT.multivar.transform}
\alias{lp.norm}
\title{Multivariate extensions of transformed empirical cdf plot}
\usage{
ecdfHT.multivar(x, scale.q = matrix(c(0.25, 0.5, 0.75), nrow = 3, ncol =
  ncol(x)), q0 = 0.5, radii.upper.tail.p = 0.9, p.norm = 2,
  show.axes.labels = FALSE, zscale = c(500, 1), ...)

ecdfHT.multivar.transform(x, scale.q, q0, p.norm)

ecdfHT.2d(multivar.obj, zscale = c(500, 1), ...)

ecdfHT.2d.axes(zscale)

lp.norm(x, p.norm)
}
\arguments{
\item{x}{Matrix of data of size (n x d)}

\item{scale.q}{matrix of sixe (3 x d), probabilities used to determine the scaling and centering for each component}

\item{q0}{quantile of radii transformation}

\item{radii.upper.tail.p}{probability used as cutuoff to tail fit; set to 1 to suppress upper tail fit}

\item{p.norm}{Power used in computing L^p norm}

\item{show.axes.labels}{Boolean value, determines if axes are labeled or not}

\item{zscale}{Vector of length 2, value of aspect ratio for the z axis when d=2 and the two 3d plots are drawn}

\item{...}{Optional graphical parameters, e.g. col='red'}

\item{multivar.obj}{An object of class 'ecdfHT.multivar', see details.}
}
\value{
\code{ecdfHT.multivar} draws several plots, returns a list (invisibly) with fields:
\describe{
\item{x}{input (n x d) matrix of data}
\item{x.prime}{(n x d) matrix of centered and shifted version of x}
\item{y}{(n x d) matrix of transformed x}
\item{p.norm}{what p-norm to use; p.norm=2 is Euclidean norm}
\item{scale.q}{copy of input argument}
\item{radii}{vector of length n, p-norm of the rows of x.prime}
\item{q0}{copy of input value}
\item{r0}{q0-th quantile of the radii}
\item{univariate.ecdfHT}{list of length d, with j-th entry the object returned by \code{ecdfHT} for the j-th column of x}
\item{radii.ecdfHT}{list returned from ecdfHT( radii, ... )}
\item{radii.tail.fit}{object returned from ecdfHT.fit for the radii )}
\item{rgl.id}{rgl id of 3d plot(s); can be used to access, change, print 3d plots}
\item{radii.prob}{if d=2, this vector gives the empirical cdf of the radii}
\item{radii.prob2}{if d=2, this vector gives the transformed empirical cdf of the radii}
}

\code{ecdfHT.multivar.transform} computes the transformed vectors y, radii, and
\code{lp.norm} computes the lp-norm of the rows of x
}
\description{
Transform multivariate data and plot using the ideas from the univariate plot.
}
\details{
\code{ecdfHT.multivar} gives a quick graphical look at a d dimensional data set.
It produces two plots: the first is a superposition of the univariate \code{ecdfHT} plots
for each component; the second plot is an array of plots, showing one plot
for each component.

\code{ecdfHT.bivar} produces two plots of a bivariate data set.
The first one has three subplots:
a scatter plot of the data, a transformed scatterplot of the data, and a univariate
\code{ecdfHT} plot of the radii of the data.
For the second and third subplot, ???? then g(y[,1]) is plotted against g(y[,2]) to get the second plot.
For the third plot, compute radius r[i]= l_p norm of shifted and scaled data.  These radii are
plotted in a univariate, one-sided \code{ecdfHT} plot.

The second plot produced is a 3-dimensonal plot.  It takes the first two subplots just described and adds a
third dimension by looking at an ecdf for the radii. Thus the height of a point is low if the point is
near the center, and increases as points move away.  The first subplot shows points
(x[i,1],x[i,2],ecdf of r[i]).  The second plot transforms all three components:
it shows (h1(x[i,1]),hs(x[i,2]),g(ecdf of r[i]), where h1(.) and h2(.) are scaled versions of
h(.) from the univariate \code{ecdfHT} plot, and g(.) is as in the univariate plot.
See the vignette for more detail.
}
\examples{
# independent components
set.seed(2)
x <- matrix( rcauchy(4000), ncol=4 )
ecdfHT.multivar( x )

# radially symmetric
r <- rcauchy(1000)
theta <- runif(1000,min=0,max=2*pi)
x <- cbind( r*cos(theta), r*sin(theta) )
ecdfHT.multivar( x )
}

