% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecmback.r
\name{ecmback}
\alias{ecmback}
\title{Backwards selection to build an error correction model}
\usage{
ecmback(y, xeq, xtr, criterion = "AIC")
}
\arguments{
\item{y}{The target variable}

\item{xeq}{The variables to be used in the equilibrium term of the error correction model}

\item{xtr}{The variables to be used in the transient term of the error correction model}

\item{criterion}{Whether AIC (default) or BIC should be used to select variables}
}
\value{
an lm object representing an error correction model using backwards selection
}
\description{
Much like the ecm function, this builds an error correction model.
However, it uses backwards selection to select the optimal predictors based on lowest AIC or BIC, rather than using all predictors.
ecmback has the same parameters and output as ecm.
}
\examples{
#Use ecm to predict Wilshire 5000 index based on corporate profits, 
#Federal Reserve funds rate, and unemployment rate
data(Wilshire)

#Use 2014-12-01 and earlier data to build models
trn <- Wilshire[Wilshire$date<='2014-12-01',]

#Use backwards selection to choose which predictors are needed 
xeq <- xtr <- trn[c('CorpProfits', 'FedFundsRate', 'UnempRate')]
modelback <- ecmback(trn$Wilshire5000, xeq, xtr, criterion = 'AIC')
print(modelback)
#Backwards selection chose CorpProfits in the equilibrium term, 
#CorpProfits and UnempRate in the transient term.

}
\seealso{
\code{lm}
}

