% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status.R
\name{status}
\alias{status}
\title{Compute Status Scores from Time Series Data}
\usage{
status(
  indicator_time_series,
  base_years = NULL,
  base_years_by_ind = NULL,
  current_years = NULL,
  current_years_by_ind = NULL,
  range = "sd",
  sign = "+",
  condition = ">"
)
}
\arguments{
\item{indicator_time_series}{A data frame with time series per state indicator.
The first column MUST be the time column.}

\item{base_years}{A vector with two numerics, specifying the time period for the baseline.
The first one \code{start} is the starting year for all state indicators
and the second one \code{end} is the end of the baseline for all state
indicators. The default is NULL. One can specify indicator specific
baseline periods using the \code{base_years_by_ind} argument.
If \code{base_years} and \code{base_years_by_ind} are NULL, then the
first 5 years of the time series are used as baseline period.}

\item{base_years_by_ind}{A data frame, specifying the baseline years for each state
indicator individually, by setting the starting year (second column)
and the end year (third column). The first column must contain the
names of the state indicators used in \code{indicator_time_series}.
The default is NULL. If \code{base_years} and \code{base_years_by_ind}
are NULL, then the first 5 years of the time series are used as baseline period.}

\item{current_years}{A vector with two numerics, specifying the time period for
the assessment period. The first one \code{start} is the starting year
for all state indicators and the second one \code{end} is the end of the
assessment period for all state indicators. The default is NULL.
One can specify indicator specific assessment periods using the
\code{current_years_by_ind} argument.
If \code{current_years} and \code{current_years_by_ind} are NULL, then the
last 5 years of the time series are used as baseline period.}

\item{current_years_by_ind}{A data frame, specifying the assessment period years
for each state indicator individually, by setting the starting year (second column)
and the end year (third column). The first column must contain the
names of the state indicators used in \code{indicator_time_series}.
The default is NULL. If \code{current_years} and \code{current_years_by_ind}
are NULL, then the last 5 years of the time series are used as assessment period.}

\item{range}{A vector specifying the allowed deviance from the baseline mean.
Can be \code{sd}, \code{2sd}, \code{95percentile} or an integer between 1 and 99
to evaluate the nth percentile. If the current mean should be compared to the
baseline mean without any deviance, please set \code{range = mean_only},
leave the default for the sign parameter and specify the condition
parameter if necessary. Default is \code{sd}.}

\item{sign}{A character vector containing \code{+} or  \code{-}, specifying
whether the upper or the lower part of the deviance should be analyzed.
Default is \code{+}.}

\item{condition}{A character vector containing \code{<} or \code{>} specifying
whether the current indicator should be above (>) or below (<) the preset
threshold range to be in a desired status. The default is \code{>}.}
}
\value{
a data frame containing the indicator name its status and the associated score,
which will be added to the indicators vulnerability to derive the risk.
}
\description{
The \code{status} function assesses whether a state indicator is in a desired
or undesired status during the assessment time period. For this the function
compares the current conditions to the baseline conditions. The user specifies
whether the mean of the current conditions should be within or outside of a
specific deviation from the baseline mean.
}
\details{
With \code{range}, \code{sign} and \code{condition} one defines good status
for the state indicators. By default the function evaluates whether the current
mean is above +1 standard deviation, if yes the status will be set to desired.
If the state should be within a range of ± standard deviation and not below that,
then the arguments \code{sign} and \code{condition} must be set to '-' and '>', this specifies
that the current mean must be higher than the mean of the baseline period - 1 standard
deviation to be considered as good status.
}
\examples{
### Demo with the internal dataset 'indicator_ts_baltic'

# Define a general baseline and current assessment period:
status(
 indicator_time_series = indicator_ts_baltic,
 base_years = c(start = 1984, end = 2010),
 current_years = c(start = 2011, end = 2016)
)

# Define indicator-specific baseline and current assessment periods:
status(
 indicator_time_series = indicator_ts_baltic,
 base_years_by_ind = data.frame(
   ind =c("zooplankton_mean_size", "eastern_baltic_cod"),
   start = c(1984, 1990), end = c(2010, 2010)
 ),
 current_years_by_ind = data.frame(
   ind =c("zooplankton_mean_size", "eastern_baltic_cod"),
   start = c(2011, 2012), end = c(2016, 2016)
 )
)
}
\seealso{
\code{\link{model_exposure}}, \code{\link{model_sensitivity}},
\code{\link{vulnerability}}, \code{\link{risk}}
}
