% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\name{ecr_result}
\alias{ecr_result}
\title{Result object.}
\description{
S3 object returned by \code{\link{doTheEvolution}} containing the best found
parameter setting and value in the single-objective case and the Pareto-front/-set
in case of a multi-objective optimization problem. Moreover a set of further
information, e.g., reason of termination, the control object etc. are returned.

The single objective result object contains the following fields:
\describe{
  \item{final.opt.state}{The last optimization state.}
  \item{task}{The \code{ecr_optimization_task}.}
  \item{control}{The \code{ecr_control} object passed to \code{\link{doTheEvolution}}.}
  \item{best.param}{Overall best parameter setting.}
  \item{best.value}{Overall best objective value.}
  \item{opt.path}{Optimization path \code{\link[ParamHelpers]{OptPath}}.}
  \item{last.population}{Last population.}
  \item{population.storage}{Named list of populations stored during the process.}
  \item{message}{Character string describing the reason of termination.}
}

In case of a solved multi-objective function the result object contains the
following fields:
\describe{
  \item{final.opt.state}{The last optimization state.}
  \item{task}{The \code{ecr_optimization_task}.}
  \item{control}{The \code{ecr_control} object passed to \code{\link{doTheEvolution}}.}
  \item{pareto.idx}{Indizes of the non-dominated solutions in the last population.}
  \item{pareto.front}{(n x d) matrix of the approximated non-dominated front where n
  is the number of non-dominated points and d is the number of objectives.}
  \item{pareto.set}{Matrix of decision space values resulting with objective values
  given in pareto.front.}
  \item{last.population}{Last population.}
  \item{population.storage}{Named list of populations stored during the process.}
  \item{message}{Character string describing the reason of termination.}
}
}

