% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{ggcov_violin}
\alias{ggcov_violin}
\title{Violin plot wrapper for discrete covariates}
\usage{
ggcov_violin(d, var, cats, ...)
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{var}{\verb{<var>} A variable to plot as unquoted name.}

\item{cats}{\verb{<var>} Optional. A vector of selected discrete variables as unquoted names.}

\item{...}{List of arguments to pass to \link[ggplot2:geom_violin]{ggplot2::geom_violin}.}
}
\value{
A ggplot object with violin plots.
}
\description{
Sugar function to generate violin plots for a chosen variable by discrete covariates.
Orientation will follow the axis of the discrete variables.
Numeric variables will be dropped, except the chosen variable to plot.
}
\examples{
iris |> ggcov_violin(Sepal.Length)
sleep |> ggcov_violin(extra,group)
sleep |> ggcov_box(extra,"group") # character for `cats` will not break
d <- mtcars |> dplyr::mutate(cyl=factor(cyl),gear=factor(gear),vs=factor(vs))
d |> ggcov_violin(mpg)
d |> ggcov_violin(mpg,c("cyl","vs"))
}
