% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/throughput_time.R
\name{throughput_time}
\alias{throughput_time}
\alias{throughput_time.eventlog}
\alias{throughput_time.grouped_eventlog}
\title{Metric: Throughput time of cases}
\usage{
throughput_time(eventlog, level, append, append_column, units, ...)

\method{throughput_time}{eventlog}(eventlog, level = c("log", "trace",
  "case"), append = FALSE, append_column = NULL, units = c("days",
  "hours", "mins", "secs", "weeks"), sort = TRUE, ...)

\method{throughput_time}{grouped_eventlog}(eventlog, level = c("log", "trace",
  "case"), append = FALSE, append_column = NULL, units = c("days",
  "hours", "mins", "secs", "weeks"), sort = TRUE, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}

\item{units}{Time units to be used}

\item{...}{Deprecated arguments}

\item{sort}{Sort by decreasing throughput time. Defaults to true. Only relevant for case level.}
}
\description{
Provides summary statistics concerning the throughput times of cases.
}
\details{
\itemize{

\item The throughput time of a case is the total duration
of the case, or the difference between the timestamp of the end event and the
timestamp of the start event of the case. Possible idle time is also included
in this calculation.
\item On log level, the summary statistics of these throughput to describe the throughput time of cases in an
aggregated fashion.
\item Instead of looking at all cases in the log, it
can be interesting to analyse the different process variants or traces in the log
}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Throughput time for eventlog

\item \code{grouped_eventlog}: Throughput time for grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
