% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing_time.R
\name{processing_time}
\alias{processing_time}
\alias{processing_time.eventlog}
\alias{processing_time.grouped_eventlog}
\alias{processing_time.activitylog}
\alias{processing_time.grouped_activitylog}
\title{Processing Time}
\usage{
processing_time(
  log,
  level = c("log", "trace", "case", "activity", "resource", "resource-activity",
    "activity-instance"),
  append = deprecated(),
  append_column = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  sort = TRUE,
  work_schedule = NULL,
  eventlog = deprecated()
)

\method{processing_time}{eventlog}(
  log,
  level = c("log", "trace", "case", "activity", "resource", "resource-activity",
    "activity-instance"),
  append = deprecated(),
  append_column = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  sort = TRUE,
  work_schedule = NULL,
  eventlog = deprecated()
)

\method{processing_time}{grouped_eventlog}(
  log,
  level = c("log", "trace", "case", "activity", "resource", "resource-activity",
    "activity-instance"),
  append = deprecated(),
  append_column = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  sort = TRUE,
  work_schedule = NULL,
  eventlog = deprecated()
)

\method{processing_time}{activitylog}(
  log,
  level = c("log", "trace", "case", "activity", "resource", "resource-activity",
    "activity-instance"),
  append = deprecated(),
  append_column = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  sort = TRUE,
  work_schedule = NULL,
  eventlog = deprecated()
)

\method{processing_time}{grouped_activitylog}(
  log,
  level = c("log", "trace", "case", "activity", "resource", "resource-activity",
    "activity-instance"),
  append = deprecated(),
  append_column = NULL,
  units = c("auto", "secs", "mins", "hours", "days", "weeks"),
  sort = TRUE,
  work_schedule = NULL,
  eventlog = deprecated()
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default), \code{"trace"}, \code{"case"},
\code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information, see \code{vignette("metrics", "edeaR")} and \strong{Details} below.}

\item{append}{\code{\link{logical}} (default \code{FALSE}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}: The arguments \code{append} and \code{append_column}
have been deprecated in favour of \code{\link{augment}}.\cr
Indicating whether to append results to original log. Ignored when level is \code{"log"} or \code{"trace"}.}

\item{append_column}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The arguments \code{append} and \code{append_column} have been deprecated in favour of \code{\link{augment}}.\cr
Which of the output columns to append to log, if \code{append = TRUE}. Default column depends on chosen level.}

\item{units}{\code{\link{character}} (default \code{"auto"}): The time unit in which the processing times should be reported. Should be one of the following values:
\code{"auto"} (default), \code{"secs"}, \code{"mins"}, \code{"hours"}, \code{"days"}, \code{"weeks"}. See also the \code{units} argument of \code{\link[=difftime]{difftime()}}.}

\item{sort}{\code{\link{logical}} (default \code{TRUE}): Sort on decreasing processing time. For \code{"case"} \code{level} only.}

\item{work_schedule}{A schedule of working hours. If provided, only working hours are counted as processing time.}

\item{eventlog}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}; please use \code{log} instead.}
}
\description{
Provides summary statistics about the processing time of the process.

In contrast to the \code{\link[=throughput_time]{throughput_time()}} of the cases in a log, the metrics concerning the active time
or the actual processing time provide summary statistics on the processing time of events on the level of the complete log,
the specific cases, traces, the activities, and the resource-activity combinations.
}
\details{
Argument \code{level} has the following options:
\itemize{
\item At \code{"log"} level, this metric calculates the summary statistics of the actual processing time per case,
summarised over the complete event log.
\item On \code{"trace"} level, the summary statistics of processing time can be calculated for each possible sequence of activities
that appears in the event log.
\item On \code{"case"} level, a list of cases with their processing time are provided.
\item On \code{"activity"} level, an overview of the average processing time -or the service time- of each activity can be calculated.
\item At \code{"resource"} level, this metric calculates the processing time per resource.
\item On \code{"resource-activity"} level, the efficiency of resources by looking at the combination of each resource
with each activity can be investigated.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{processing_time(eventlog)}: Computes processing time for an \code{\link[bupaR:eventlog]{eventlog}}.

\item \code{processing_time(grouped_eventlog)}: Computes processing time for a \code{\link[bupaR:grouped_eventlog]{grouped_eventlog}}.

\item \code{processing_time(activitylog)}: Computes processing time for an \code{\link[bupaR:activitylog]{activitylog}}.

\item \code{processing_time(grouped_activitylog)}: Computes processing time for a \code{\link[bupaR:grouped_activitylog]{grouped_activitylog}}.

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link[=idle_time]{idle_time()}},\code{\link[=throughput_time]{throughput_time()}},\code{\link[=difftime]{difftime()}}

Other metrics: 
\code{\link{activity_frequency}()},
\code{\link{activity_presence}()},
\code{\link{end_activities}()},
\code{\link{idle_time}()},
\code{\link{number_of_repetitions}()},
\code{\link{number_of_selfloops}()},
\code{\link{number_of_traces}()},
\code{\link{resource_frequency}()},
\code{\link{resource_involvement}()},
\code{\link{resource_specialisation}()},
\code{\link{start_activities}()},
\code{\link{throughput_time}()},
\code{\link{trace_coverage}()},
\code{\link{trace_length}()}
}
\concept{metrics}
\concept{metrics_time}
