% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{pivot_wider_by}
\alias{pivot_wider_by}
\title{Pivot factor to a wider list}
\usage{
pivot_wider_by(
  data,
  id_cols = NULL,
  id_expand = FALSE,
  names_from = where(is_trt),
  names_prefix = "",
  names_sep = ":",
  names_glue = NULL,
  names_sort = FALSE,
  names_vary = "fastest",
  names_expand = FALSE,
  names_repair = "check_unique",
  values_from = NULL,
  values_fill = NULL,
  values_fn = NULL
)
}
\arguments{
\item{data}{An edibble table}

\item{id_cols}{Columns in the data where the levels correspond to a unique
level on the row.}

\item{id_expand}{If multiple columns are selected, whether all combinations of
the levels should be taken into account.}

\item{names_from}{An expression specifying which columns to pivot from.}

\item{names_prefix}{A prefix to add to the resulting column names.}

\item{names_sep}{A separator to use between column names in the resulting wide format.}

\item{names_glue}{A glue specification to control column names.}

\item{names_sort}{A logical indicating whether to sort the resulting column names.}

\item{names_vary}{A character vector of options to specify how to handle varying identifiers.}

\item{names_expand}{A logical indicating whether to expand identifiers in the column names.}

\item{names_repair}{A method to handle non-unique resulting column names.}

\item{values_from}{A character vector specifying columns to use as values in the wide format.}

\item{values_fill}{A value or function to fill missing values.}

\item{values_fn}{A function to aggregate values.}
}
\description{
This function makes it easier to see which units or records are associated
with a particular level of factor.
The arguments closely follow \code{\link[tidyr:pivot_wider]{tidyr::pivot_wider()}}, but the major difference
is that it is aware of the relationships between columns and makes use of
this to present to you information without unnecessary duplication.
}
\seealso{
\code{\link[=split_by]{split_by()}} and \code{\link[=count_by]{count_by()}}
}
\keyword{internal}
