% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check}
\alias{check}
\title{Remove empty cues and/or outcomes.}
\usage{
check(data, rm = TRUE)
}
\arguments{
\item{data}{Data frame with columns \code{Cues} and \code{Outcomes}.}

\item{rm}{Logical: whether or not to remove empty strings. (Default TRUE).}
}
\value{
data frame or numeric vector (see details)
}
\description{
Remove empty cues and/or outcomes.
}
\details{
When \code{rm=FALSE} the function returns a code for each row of the data 
frame indicating whether an empty cue or outcome was detected. 
The function may return the following values:
\describe{
    \item{0}{No empty cues and outcomes were detected in this row.}
    \item{1}{Empty cue(s) but not empty outcomes were detected in this row.}
    \item{2}{Empty outcome(s) but not empty cues were detected in this row.}
    \item{3}{Empty cue(s) AND empty outcome(s) were detected in this row.}
}
}
\examples{
test1 <- c("a_b", "a__b", "_a_b", "a_b_", "_a__b_", "___")
\dontrun{
    # this returns an error:
    check(test1)
}
# data frame with cues and outcomes:
(dat <- data.frame(Cues=test1, Outcomes=sample(test1), stringsAsFactors=TRUE))
# remove empty:
check(dat)
# only indicating which rows contain empty cues/outcomes:
(test <- check(dat, rm=FALSE))
# check empty cues:
dat[test \%in\% c(1,3),]
# check empty outcomes:
dat[test \%in\% c(2,3),]

}
\author{
Jacolien van Rij
}
