% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdp.R
\name{sdp}
\alias{sdp}
\title{Semi-Definite Programming Algorithm}
\usage{
sdp(D, A, toler = 1e-08)
}
\arguments{
\item{D}{An nxn partial-distance matrix to be completed. D must satisfy a list of conditions (see details), with unkown entries set to NA.}

\item{A}{a weight matrix, with \eqn{h_{ij} = 0} implying \eqn{a_{ij}} is unknown. Generally, if \eqn{a_{ij}} is known, \eqn{h_{ij} = 1}, although any non-negative weight is allowed.}

\item{toler}{convergence tolerance for the algorithm}
}
\value{
\item{D}{an nxn matrix of the completed Euclidean distances}
\item{optval}{the minimum value achieved of the target function during minimization}
}
\description{
\code{sdp} returns a completed Euclidean Distance Matrix D, with dimension d,
from a partial Euclidean Distance Matrix using the methods of Alfakih et. al. (1999)
}
\details{
This is an implementation of the Semi-Definite Programming Algorithm (sdp)
for Euclidean Distance Matrix Completion, as proposed in 'Solving Euclidean 
Distance Matrix Completion Problems via Semidefinite Programming' (Alfakih et. al., 1999).

The method seeks to minimize the following:

\deqn{||A \cdot (D - psd2edm(S))||_{F}^{2}}

where the function psd2edm() is that described in psd2edm(), and the norm is Frobenius. Minimization is over S, a positive semidefinite matrix.

The matrix D is a partial-distance matrix, meaning some of its entries are unknown. 
It must satisfy the following conditions in order to be completed:
\itemize{
\item{diag(D) = 0}
\item{If \eqn{a_{ij}} is known, \eqn{a_{ji} = a_{ij}}}
\item{If \eqn{a_{ij}} is unknown, so is \eqn{a_{ji}}}
\item{The graph of D must be connected. If D can be decomposed into two (or more) subgraphs, 
   then the completion of D can be decomposed into two (or more) independent completion problems.}
}
}
\examples{

\donttest{
D <- matrix(c(0,3,4,3,4,3,
             3,0,1,NA,5,NA,
             4,1,0,5,NA,5,
             3,NA,5,0,1,NA,
             4,5,NA,1,0,5,
             3,NA,5,NA,5,0), byrow=TRUE, nrow=6)
A <- matrix(c(1,1,1,1,1,1,
             1,1,1,0,1,0,
             1,1,1,1,0,1,
             1,0,1,1,1,0,
             1,1,0,1,1,1,
             1,0,1,0,1,1), byrow=TRUE, nrow=6)
             
edmc(D, method="sdp", A=A, toler=1e-2)
}

}
\seealso{
\code{\link{psd2edm}}
}
