% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eglm-wfit.R
\name{eglm.wfit}
\alias{eglm.wfit}
\title{Fitting Generalized Linear Models}
\usage{
eglm.wfit(
  x,
  y,
  weights = rep.int(1, nobs),
  start = NULL,
  etastart = NULL,
  mustart = NULL,
  offset = rep.int(0, nobs),
  family = gaussian(),
  control = list(),
  intercept = TRUE,
  singular.ok = TRUE,
  reduce = FALSE
)
}
\arguments{
\item{x, y}{For \code{eglm.wfit}: x is a design matrix of dimension
\code{n * p}, and y is a vector of observations of length n, or a matrix
with n rows.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Should be \code{NULL} or a numeric vector. If non-NULL, weighted
least squares is used with weights \code{weights} (that is, minimizing
\code{sum(w*e^2)}); otherwise ordinary least squares is used.}

\item{start}{starting values for the parameters in the linear predictor.}

\item{etastart}{starting values for the linear predictor.}

\item{mustart}{starting values for the vector of means.}

\item{offset}{this can be used to specify an \emph{a priori} known component
to be included in the linear predictor during fitting. This should be
\code{NULL} or a numeric vector or matrix of extents matching those of the
response. One or more \code{\link{offset}} terms can be included in the
formula instead or as well, and if more than one are specified their sum is
used. See \code{\link{model.offset}}.}

\item{family}{a description of the error distribution and link function to be
used in the model. This can be a character string naming a
family function, a family function or the result of a call to a family
function. See \code{\link{family}} for details of family functions.}

\item{control}{a list of parameters for controlling the fitting process. For
\code{eglm.wfit} this is passed to \code{glm.control}.}

\item{intercept}{logical value indicating whether \emph{intercept} should be
included in the \emph{null} model. Defaults to \code{TRUE}.}

\item{singular.ok}{logical; if FALSE a singular fit is an error.}

\item{reduce}{logical; if TRUE an alternate design matrix of \code{p * p} is
used for the fitting instead of the traditional \code{n * p} design matrix.}
}
\value{
A list that contains the same elements as the output from
\code{"\link{glm.fit}"}, with the addition of the vector "good" that
indicates with logicals which observations were used in the fitting process.
}
\description{
Efficient Generalized Linear Model Weighted Fit (\code{"eglm.wfit"}) is used
to fit generalized linear models in an equivalent way to
\code{"\link{glm.fit}"} but in a reduced time depending on the design matrix
and the family (or link).
}
\details{
\code{eglm.wfit} is a workhorse function: it is not normally called
directly but can be more efficient where the response vector, design matrix
and family have already been calculated. Use \code{eglm} for most of the
cases.
}
\examples{
x <- cbind(rep(1, nrow(mtcars)), mtcars$wt)
y <- mtcars$mpg
eglm.wfit(x, y)
}
