% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elm-wfit.R
\name{elm.wfit}
\alias{elm.wfit}
\title{Fitting Linear Models}
\usage{
elm.wfit(
  x,
  y,
  weights = rep.int(1, n),
  offset = NULL,
  method = "qr",
  tol = 1e-07,
  singular.ok = TRUE,
  reduce = TRUE,
  ...
)
}
\arguments{
\item{x}{logical values indicating whether the
\emph{model matrix} (\code{x}) and the \emph{response vector} (\code{y})
used in the fitting process should be returned as components of the returned
value.}

\item{y}{logical values indicating whether the
\emph{model matrix} (\code{x}) and the \emph{response vector} (\code{y})
used in the fitting process should be returned as components of the returned
value.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Should be \code{NULL} or a numeric vector. If non-NULL, weighted
least squares is used with weights \code{weights} (that is, minimizing
\code{sum(w*e^2)}); otherwise ordinary least squares is used.}

\item{offset}{this can be used to specify an \emph{a priori} known component
to be included in the linear predictor during fitting. This should be
\code{NULL} or a numeric vector or matrix of extents matching those of the
response. One or more \code{\link{offset}} terms can be included in the
formula instead or as well, and if more than one are specified their sum is
used. See \code{\link{model.offset}}.}

\item{method}{the method to be used in fitting the model. The default method
\code{"eglm.wfit"} uses iteratively reweighted least squares (IWLS): the
alternative \code{"model.frame"} returns the model frame and does no
fitting. User-supplied fitting functions can be supplied either as a
function or a character string naming a function, with a function which
takes the same arguments as \code{glm.fit} from the \bold{stats} package.
If specified as a character string it is looked up from within the
\bold{eflm} namespace.}

\item{tol}{tolerance for the \code{\link{qr}} decomposition. Default is 1e-7.}

\item{singular.ok}{logical; if FALSE a singular fit is an error.}

\item{reduce}{logical; if TRUE an alternate design matrix of \code{p * p} is
used for the fitting instead of the traditional \code{n * p} design matrix.}

\item{...}{For eglm: arguments to be used to form the default control
argument if it is not supplied directly. For weights: further arguments
passed to or from other methods.}
}
\value{
A list that contains the same elements as the output from
\code{"\link{lm.fit}"}.
}
\description{
Efficient Linear Model Weighted Fit (\code{"elm.wfit"}) is used
to fit linear models in an equivalent way to \code{"\link{glm.fit}"} but in
a reduced time depending on the design matrix and the family (or link).
}
\details{
\code{elm.wfit} is a workhorse function: it is not normally called
directly but can be more efficient where the response vector, design matrix
and family have already been calculated. Use \code{elm} for most of the
cases.
}
\examples{
x <- cbind(rep(1, nrow(mtcars)), mtcars$wt)
y <- mtcars$mpg
elm.wfit(x, y)
}
