\name{cal.window}
\alias{cal.window}

\title{Calendar time cut of survival data}
\description{For a given time interval, each spell is cut so that it
  fully lies in the given time interval
}
\usage{
cal.window(dat, window, surv=c("enter", "exit", "event", "birthdate"))
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{dat}{Input data frame. Must contain survival data and a birth date.}
  \item{window}{Vector of length two; the time interval}
  \item{surv}{Vector of length four giving the names of the central
    variables in 'dat'.}
}
\details{
The \code{window} must be in the order \code{(begin, end)}
}
\value{
  A data frame of the same form as the input data frame, but 'cut' as
  desired. Intervals exceeding \code{window[2]} will be given
  \code{event = 0}
  
}
%\references{ ~put references to the literature/web site here ~ }
\author{Gran Brostrm}
%\note{ ~~further notes~~ }

 ~Make other sections like WARNING with \section{WARNING }{....} ~

\seealso{\code{\link{age.window}}, \code{\link{coxreg}}, \code{\link{mlreg}}}

\examples{
dat <- data.frame(enter = 0, exit = 5.731, event = 1,
birthdate = 1962.505, x = 2)
window <- c(1963, 1965)
dat.trim <- cal.window(dat, window)  
}
\keyword{survival}% at least one, from doc/KEYWORDS

