% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_raster.R
\name{wrf_raster}
\alias{wrf_raster}
\title{Creates raster from a variable from a wrf file}
\usage{
wrf_raster(
  file = file.choose(),
  name = NA,
  latlon = FALSE,
  level = 1,
  use_sf = FALSE,
  as_polygons = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{wrf file}

\item{name}{variable name}

\item{latlon}{project the output in "+proj=longlat +datum=WGS84 +no_defs"}

\item{level}{only for 4d data, default is 1 (surface)}

\item{use_sf}{set TRUE to use sf package instead of rgdal to project XLAT/XLONG}

\item{as_polygons}{logical, true to return a poligon instead of a raster}

\item{verbose}{display additional information}
}
\value{
return a raster from a NetCDF WRF file
}
\description{
Return a Raster
}
\note{
newer versions of gdal/rgdal can present a issue related to lat/lon
set use_sf to TRUE use functions of sf instead of rgdal
}
\examples{
{

wrf <- paste(system.file("extdata", package = "eixport"),
                         "/wrfinput_d02", sep="")

r <- wrf_raster(file=wrf, name='XLAT')

library(raster)
plot(r, axes = TRUE)
}
}
