% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_bulk_update.R
\name{docs_bulk_update}
\alias{docs_bulk_update}
\title{Use the bulk API to update documents}
\usage{
docs_bulk_update(x, index = NULL, type = NULL, chunk_size = 1000,
  doc_ids = NULL, raw = FALSE, ...)
}
\arguments{
\item{x}{A list, data.frame, or character path to a file. required.}

\item{index}{(character) The index name to use. Required for data.frame
input, but optional for file inputs.}

\item{type}{(character) The type name to use. If left as NULL, will be
same name as index.}

\item{chunk_size}{(integer) Size of each chunk. If your data.frame is smaller
thank \code{chunk_size}, this parameter is essentially ignored. We write in
chunks because at some point, depending on size of each document, and
Elasticsearch setup, writing a very large number of documents in one go
becomes slow, so chunking can help. This parameter is ignored if you
pass a file name. Default: 1000}

\item{doc_ids}{An optional vector (character or numeric/integer) of document
ids to use. This vector has to equal the size of the documents you are
passing in, and will error if not. If you pass a factor we convert to
character. Default: not passed}

\item{raw}{(logical) Get raw JSON back or not. If \code{TRUE}
you get JSON; if \code{FALSE} you get a list. Default: \code{FALSE}}

\item{...}{Pass on curl options to \code{\link[httr:POST]{httr::POST()}}}
}
\description{
Use the bulk API to update documents
}
\details{
\itemize{
\item \code{doc_as_upsert} - is set to \code{TRUE} for all records
}

For doing updates with a file already prepared for the bulk API,
see \code{\link[=docs_bulk]{docs_bulk()}}

Only data.frame's are supported for now.
}
\examples{
\dontrun{
connect()
if (index_exists("foobar")) index_delete("foobar")

df <- data.frame(name = letters[1:3], size = 1:3, id = 100:102)
invisible(docs_bulk(df, 'foobar', 'foobar', es_ids = FALSE))

# add new rows in existing fields
(df2 <- data.frame(size = c(45, 56), id = 100:101))
Search("foobar", asdf = TRUE)$hits$hits
invisible(docs_bulk_update(df2, index = 'foobar', type = 'foobar'))
Search("foobar", asdf = TRUE)$hits$hits

# add new fields (and new rows by extension)
(df3 <- data.frame(color = c("blue", "red", "green"), id = 100:102))
Search("foobar", asdf = TRUE)$hits$hits
invisible(docs_bulk_update(df3, index = 'foobar', type = 'foobar'))
Search("foobar", asdf = TRUE)$hits$hits
}
}
\references{
\url{https://www.elastic.co/guide/en/elasticsearch/reference/6.2/docs-bulk.html#bulk-update}
}
\seealso{
\code{\link[=docs_bulk]{docs_bulk()}} \code{\link[=docs_bulk_prep]{docs_bulk_prep()}}
}
