% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-bedrock.R
\name{chat_aws_bedrock}
\alias{chat_aws_bedrock}
\alias{models_aws_bedrock}
\title{Chat with an AWS bedrock model}
\usage{
chat_aws_bedrock(
  system_prompt = NULL,
  model = NULL,
  profile = NULL,
  api_args = list(),
  echo = NULL
)

models_aws_bedrock(profile = NULL)
}
\arguments{
\item{system_prompt}{A system prompt to set the behavior of the assistant.}

\item{model}{The model to use for the chat (defaults to "anthropic.claude-3-5-sonnet-20240620-v1:0").
We regularly update the default, so we strongly recommend explicitly specifying a model for anything other than casual use.
Use \code{models_models_aws_bedrock()} to see all options.
.

While ellmer provides a default model, there's no guarantee that you'll
have access to it, so you'll need to specify a model that you can.
If you're using \href{https://aws.amazon.com/blogs/machine-learning/getting-started-with-cross-region-inference-in-amazon-bedrock/}{cross-region inference},
you'll need to use the inference profile ID, e.g.
\code{model="us.anthropic.claude-3-5-sonnet-20240620-v1:0"}.}

\item{profile}{AWS profile to use.}

\item{api_args}{Named list of arbitrary extra arguments appended to the body
of every chat API call. Some useful arguments include:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{api_args = list(
  inferenceConfig = list(
    maxTokens = 100,
    temperature = 0.7,
    topP = 0.9,
    topK = 20
  )
)
}\if{html}{\out{</div>}}}

\item{echo}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{text}: echo text output as it streams in (default when running at
the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\value{
A \link{Chat} object.
}
\description{
\href{https://aws.amazon.com/bedrock/}{AWS Bedrock} provides a number of
language models, including those from Anthropic's
\href{https://aws.amazon.com/bedrock/claude/}{Claude}, using the Bedrock
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html}{Converse API}.
\subsection{Authentication}{

Authentication is handled through \{paws.common\}, so if authentication
does not work for you automatically, you'll need to follow the advice
at \url{https://www.paws-r-sdk.com/#credentials}. In particular, if your
org uses AWS SSO, you'll need to run \verb{aws sso login} at the terminal.
}
}
\examples{
\dontrun{
# Basic usage
chat <- chat_aws_bedrock()
chat$chat("Tell me three jokes about statisticians")
}
}
\seealso{
Other chatbots: 
\code{\link{chat_anthropic}()},
\code{\link{chat_azure_openai}()},
\code{\link{chat_cloudflare}()},
\code{\link{chat_cortex_analyst}()},
\code{\link{chat_databricks}()},
\code{\link{chat_deepseek}()},
\code{\link{chat_github}()},
\code{\link{chat_google_gemini}()},
\code{\link{chat_groq}()},
\code{\link{chat_huggingface}()},
\code{\link{chat_mistral}()},
\code{\link{chat_ollama}()},
\code{\link{chat_openai}()},
\code{\link{chat_openrouter}()},
\code{\link{chat_perplexity}()},
\code{\link{chat_portkey}()}
}
\concept{chatbots}
