% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elo.functions.R
\name{elo.functions}
\alias{elo.functions}
\alias{elo.prob}
\alias{elo.update}
\alias{elo.calc}
\title{Elo functions}
\usage{
elo.prob(elo.A, elo.B)

elo.update(elo.A, elo.B, wins.A, k)

elo.calc(elo.A, elo.B, wins.A, k)
}
\arguments{
\item{elo.A, elo.B}{Numeric vectors of elo scores.}

\item{wins.A}{Numeric vector of wins by team A.}

\item{k}{Numeric vector or scalar of k-values.}
}
\description{
\code{elo.prob} calculates the probability that team A beats team B.
\code{elo.update} calculates the update value for a given Elo matchup, and is used in
\code{elo.calc}, which reports the post-update Elo values.
}
\details{
These are all vectorized.


  Originally, I was going to script these in Rcpp, but the performance benefits are only realized
  when the vectors get to be ~1000 elements long.
}
\examples{
elo.prob(1500, 1500)
elo.prob(c(1500, 1500), c(1500, 1600))

elo.update(c(1500, 1500), c(1500, 1600), c(1, 0), k = 20)
elo.calc(c(1500, 1500), c(1500, 1600), c(1, 0), k = 20)
}
