% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.elo.markovchain.R
\name{predict.elo.markovchain}
\alias{predict.elo.markovchain}
\title{Make Predictions on an \code{elo.markovchain} Object}
\usage{
\method{predict}{elo.markovchain}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class \code{"\link{elo.markovchain}"}.}

\item{newdata}{A new dataset containing the same variables as the call
that made \code{object}. If missing, the predicted win probabilities from
\code{object} will be returned.}

\item{...}{Other arguments.}
}
\value{
A vector of win probabilities.
}
\description{
Make Predictions on an \code{elo.markovchain} Object
}
\examples{
data(tournament)
t1 <- head(tournament, -3)
t2 <- tail(tournament, 3)
results <- elo.markovchain(score(points.Home, points.Visitor) ~ team.Home + team.Visitor, data = t1,
  subset = points.Home != points.Visitor, k = 0.7)
predict(results)
predict(results, newdata = t2)
}
\seealso{
\code{\link{predict.elo.running}}
}
