% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.elo}
\alias{summary.elo}
\alias{summary.elo.run}
\alias{summary.elo.glm}
\alias{summary.elo.markovchain}
\alias{summary.elo.colley}
\alias{summary.elo.winpct}
\title{Summarize an \code{elo} Object}
\usage{
\method{summary}{elo.run}(object, ...)

\method{summary}{elo.glm}(object, ...)

\method{summary}{elo.markovchain}(object, ...)

\method{summary}{elo.colley}(object, ...)

\method{summary}{elo.winpct}(object, ...)
}
\arguments{
\item{object}{An object to summarize.}

\item{...}{Other arguments}
}
\value{
A summary of \code{object}.
}
\description{
Summarize an \code{elo} Object
}
\examples{
summary(elo.run(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
  data = tournament, k = 20))
summary(elo.glm(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
  data = tournament))
mc <- elo.markovchain(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
  data = tournament, subset = points.Home != points.Visitor, k = 0.7)
summary(mc)
co <- elo.colley(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
  data = tournament, subset = points.Home != points.Visitor)
summary(co)
wp <- elo.winpct(score(points.Home, points.Visitor) ~ team.Home + team.Visitor,
  data = tournament, subset = points.Home != points.Visitor, k = 0.7)
summary(wp)
}
\seealso{
\code{\link{favored}}, \code{\link{auc.elo.run}}, \code{\link{mse}}
}
