% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.fit_routines.R
\name{em.glm_pracma_fit}
\alias{em.glm_pracma_fit}
\title{Hessian routine}
\usage{
em.glm_pracma_fit(x, y, b.list, class_probs, weight = c(1), K = 2,
  tol.1 = 1e-08, debug = FALSE, family = poisson(), maxiter = Inf)
}
\arguments{
\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{b.list}{List of K-classes each entry being a k length parameter vector,}

\item{class_probs}{Matrix (n x K) of normalized class probabilities.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{K}{Number of EM classes to be fit.}

\item{tol.1}{Tolerance of the NR minimization.}

\item{debug}{Boolen flag. Turn on to check optimization steps via messages.}

\item{family}{GLM family to fit with.}

\item{maxiter}{Maximum iterations of the NR methods for exiting before convergence.}
}
\value{
A list of parameter values on convergence for each of k-classes.
}
\description{
Hessian routine
}
\examples{
x <- model.matrix(~ 1 , data = warpbreaks)
y <- warpbreaks$breaks

b.list <- list(1, 1)
class_probs = matrix(rep(0.5, 54*2), ncol = 2)

em.glm_pracma_fit(x = x, y = y, b.list = b.list, class_probs = class_probs)

}
