% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MovingIncubation.R
\name{MovingIncubation}
\alias{MovingIncubation}
\title{Simulate incubation of a nest with the beginning of incubation varying}
\usage{
MovingIncubation(
  NestsResult = NULL,
  resultmcmc = NULL,
  GTRN.CI = "Hessian",
  tsd = NULL,
  tsd.CI = NULL,
  tsd.mcmc = NULL,
  SexualisationTRN = NULL,
  SexualisationTRN.CI = "Hessian",
  SexualisationTRN.mcmc = NULL,
  temperatures.df = stop("A data.frame must be provided"),
  temperature.heterogeneity = 0,
  metabolic.heating = 0,
  average.incubation.duration = 60 * 1440,
  max.time = 100 * 24 * 60,
  skip = 1,
  parameters = NULL,
  fixed.parameters = NULL,
  SE = NULL,
  hessian = NULL,
  integral = NULL,
  derivate = NULL,
  hatchling.metric = NULL,
  M0 = NULL,
  embryo.stages = "Caretta caretta.SCL",
  TSP.borders = c(21, 26),
  TSP.begin = 0,
  TSP.end = 0.5,
  replicate.CI = 1,
  parallel = TRUE,
  progressbar = TRUE
)
}
\arguments{
\item{NestsResult}{A result file generated by searchR}

\item{resultmcmc}{A mcmc result. Will be used rather than SE if provided.}

\item{GTRN.CI}{How to estimate CI for embryo growth thermal reaction norm; can be NULL, "SE", "MCMC", "pseudohessianfrommcmc" or "Hessian".}

\item{tsd}{A object from tsd() that describe the thermal react norm of sex ratio at constant temperatures}

\item{tsd.CI}{How to estimate CI for sex ratio thermal reaction norm; Can be NULL, "SE", "MCMC", "pseudohessianfrommcmc" or "Hessian".}

\item{tsd.mcmc}{A object from tsd_MHmcmc()}

\item{SexualisationTRN}{A model for sexualisation thermal reaction norm during TSP obtained using STRN()}

\item{SexualisationTRN.CI}{How to estimate CI of sexualisation thermal reaction norm. Can be NULL, "SE", "MCMC", "pseudohessianfrommcmc" or "Hessian".}

\item{SexualisationTRN.mcmc}{MCMC object for STRN.}

\item{temperatures.df}{A data.frame with 2 or 3 columns: Times, Temperatures and Temperatures.end.incubation (facultative)}

\item{temperature.heterogeneity}{SD of heterogeneity of temperatures. Can be 2 values, sd_low and sd_high and then HelpersMG::r2norm() is used.}

\item{metabolic.heating}{Degrees Celsius to be added at the end of incubation due to metabolic heating}

\item{average.incubation.duration}{The average time to complete incubation (not used if metabolic heating is setup)}

\item{max.time}{Maximum time of incubation}

\item{skip}{Number of data to skip between two runs}

\item{parameters}{A set of parameters if result is not provided.}

\item{fixed.parameters}{Another set of parameters if result is not provided.}

\item{SE}{Standard error for each parameter if not present in result is not provided}

\item{hessian}{A hessian matrix}

\item{integral}{Function used to fit embryo growth: integral.Gompertz, integral.exponential or integral.linear}

\item{derivate}{Function used to fit embryo growth: dydt.Gompertz, dydt.exponential or dydt.linear. It will replace the one in NestsResult.}

\item{hatchling.metric}{Mean and SD of size of hatchlings as a vector ie hatchling.metric=c(Mean=xx, SD=yy)}

\item{M0}{Measure of hatchling size proxi at laying date}

\item{embryo.stages}{The embryo stages. At least TSP.borders stages must be provided to estimate TSP length}

\item{TSP.borders}{The limits of TSP}

\item{TSP.begin}{Where TSP begin during the stage of beginning? In relative proportion of the stage.}

\item{TSP.end}{Where TSP begin during the stage of ending? In relative proportion of the stage.}

\item{replicate.CI}{Number of randomizations to estimate CI}

\item{parallel}{Should parallel computing be used. TRUE or FALSE}

\item{progressbar}{Should a progress bar be shown ? TRUE or FALSE}
}
\value{
A dataframe with informations about thermosensitive period length and incubation length day by day of incubation
}
\description{
Simulate incubation of a nest with the beginning varying day by day\cr
Temperatures must be in a data.frame with one column (Time) being the time and the second the temperatures (Temperature). A third columns can indicate the temperature at the end of incubation (Temperature.end.incubation). Do not use FormatNests() for this dataframe.
}
\details{
MovingIncubation simulate incubation of a nest with the beginning varying day by day
}
\examples{
\dontrun{
library(embryogrowth)
data(resultNest_4p_SSM)
ti <- seq(from=0, to=(60*24*100), by=60)
temperatures <- rnorm(length(ti), 29, 5)
temperatures <- temperatures+ti/(60*24*100)/2
layout(mat=1:3)
parpre <- par(mar=c(4, 4, 1, 1)+0.4)
plot(ti/(60*24), temperatures, type="l", xlab="Days", 
     ylab=expression("Nest temperature in "*degree*"C"), bty="n", las=1)
# The sexualisation thermal reaction norm is calculated for South Pacific RMU
out <- MovingIncubation(NestsResult=resultNest_4p_SSM, 
     temperatures.df=data.frame(Time=ti, Temperature=temperatures),
     metabolic.heating = 0, 
     SexualisationTRN = structure(c(71.922411148397, 613.773055147801, 
     318.059753164125, 120.327257089974), 
     .Names = c("DHA", "DHH", "T12H", "Rho25")))
with(out, plot(Time/(60*24), Incubation.length.mean/(60*24), 
     xlab="Days along the season", 
     ylab="Incubation duration", 
     type="l", bty="n", las=1, ylim=c(70, 80)))
with(out, plot(Time/(60*24), TSP.GrowthWeighted.STRNWeighted.temperature.mean, 
     xlab="Days along the season", 
     ylab=expression("CTE for sex ratio in "*degree*"C"), 
      type="l", bty="n", las=1, ylim=c(30, 31)))
par(mar=parpre)
layout(mat=c(1))
}
}
\author{
Marc Girondot
}
