% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{factor_to_logical}
\alias{factor_to_logical}
\title{Convert factors to logicals}
\usage{
factor_to_logical(x, base = 1L, drop = TRUE)
}
\arguments{
\item{x}{Factor.}

\item{base}{Level to consider as the basis for comparison. Can be either
integer or character.
Note that \code{base = 4} is interpreted as a level named "4",
but \code{base = 4L} is interpreted as the fourth level.}

\item{drop}{Whether to keep the base level. The base level column never holds
any information that cannot be deduced from the remaining columns.}
}
\description{
Factors are converted to logical vectors or matrices depending on the number
of levels. Ordered factors are converted to matrices where each column
represent a level, coded \code{TRUE} for observations that match the level
and \code{FALSE} otherwise.
Unordered factors are converted in a similar way but coded \code{TRUE} for
observations that match the level \emph{or a higher level}.
Interpred in words, the star rating example below returns a matrix containing 
a column named \dQuote{3 stars} that contains \code{TRUE} for observations
with at least three stars and \code{FALSE} for observations with fewer than
three stars.
}
\examples{
# Binary factor
email <- factor(sample(2, 20, TRUE), labels=c("unverified", "verified"))
factor_to_logical(email)

# Unordered multi-level factors
wine_preferences <- factor(sample(3, 20, TRUE), 
                           labels=c("red", "white", "none"))
factor_to_logical(wine_preferences, base="none")

fruit <- factor(sample(4, 20, TRUE),
                labels = c("apple", "banana", "cantaloup", "durian"))
fruit[sample(length(fruit), 3)] <- NA
factor_to_logical(fruit, drop=FALSE)

# Ordered factor
rating <- factor(1:5, labels = paste(1:5, "stars"), ordered=TRUE)
factor_to_logical(rating)

# Ordered factor with custom base
tie_break <- factor(1:5, 
                    labels=c("SetAlice", "AdvAlice", "Deuce", "AdvBob", "SetBob"),
                    ordered = TRUE)
tie_status <- as.data.frame(
    factor_to_logical(tie_break, base="Deuce", drop=FALSE)
)
print(tie_status)
tie_break[tie_status$AdvAlice]
tie_break[tie_status$SetBob]
tie_break[tie_status$Deuce]
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

