% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.r
\name{pre_impute_df}
\alias{pre_impute_df}
\title{Impute a data frame}
\usage{
pre_impute_df(data, class_fun = list(numeric = function(x) median(x, na.rm =
  TRUE), integer = function(x) median(x, na.rm = TRUE)),
  default_fun = function(x) mode(x, na.rm = TRUE, allow_multiple = FALSE))
}
\arguments{
\item{data}{Pre-processed data set with features in a data frame.}

\item{class_fun}{List of functions to use for imputating specific feature
classes.}

\item{default_fun}{Function to use for imputation features of classes not
listed in \code{class_fun}.}

\item{na.rm}{Whether to remove missing values.}
}
\description{
This function imputes each column of data frames univariately with different
functions depending on their class.
}
\examples{
x <- iris
x[sample(150, 3), 1] <- NA                                                                          
x[sample(150, 1), 3] <- NA
x[sample(150, 5), 5] <- NA
y <- gl(2, 75)
fold <- resample("holdout", y, nfold=1)[[1]]
data <- pre_split(x, y, fold) \%>\%
    pre_impute_df
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

