% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emtrends.R
\name{emtrends}
\alias{emtrends}
\title{Estimated marginal means of linear trends}
\usage{
emtrends(model, specs, var, delta.var = 0.001 * rng, data,
  transform = c("none", "response"), max.degree = 1, ...)
}
\arguments{
\item{model}{A supported model object (\emph{not} a reference grid)}

\item{specs}{Specifications for what marginal trends are desired -- as in
\code{\link{emmeans}}}

\item{var}{Character value giving the name of a variable with respect to 
which a difference quotient of the linear predictors is computed. In order
for this to be useful, \code{var} should be a numeric predictor that
interacts with at least one factor in \code{specs}. Then instead of
computing EMMs, we compute and compare the slopes of the \code{var} trend
over levels of the specified other predictor(s). As in EMMs, marginal
averages are computed for the predictors in \code{specs} and \code{by}.
See also the \dQuote{Generalizations} section below.}

\item{delta.var}{The value of \emph{h} to use in forming the difference
quotient \eqn{(f(x+h) - f(x))/h}. Changing it (especially changing its
sign) may be necessary to avoid numerical problems such as logs of negative
numbers. The default value is 1/1000 of the range of \code{var} over the
dataset.}

\item{data}{As in \code{\link{ref_grid}}, you may use this argument to supply
the dataset used in fitting the model, for situations where it is not
possible to reconstruct the data. Otherwise, leave it missing.}

\item{transform}{If \code{object} has a response
transformation or link function, then specifying 
\code{transform = "response"} will cause
\code{emtrends} to calculate the trends after back-transforming to the
response scale. This is done using the chain rule, and standard errors are
estimated via the delta method. With \code{transform = "none"} (the
default), the trends are calculated on the scale of the linear predictor,
without back-transforming it. This argument works similarly to the
\code{transform} argument in \code{\link{ref_grid}}, in that the returned
object is re-gridded to the new scale (see also \code{\link{regrid}}).}

\item{max.degree}{Integer value. The maximum degree of trends to compute (this
is capped at 5). If greater than 1, an additional factor \code{degree} is
added to the grid, with corresponding numerical derivatives of orders
\code{1, 2, ..., max.degree} as the estimates.}

\item{...}{Additional arguments passed to other methods or to 
\code{\link{ref_grid}}}
}
\value{
An \code{emmGrid} or \code{emm_list} object, according to \code{specs}.
See \code{\link{emmeans}} for more details on when a list is returned.
}
\description{
The \code{emtrends} function is useful when a fitted model involves a
numerical predictor \eqn{x}  interacting with another predictor \code{a}
(typically a factor). Such models specify that \eqn{x} has a different trend
depending on \eqn{a}; thus, it may be of interest to estimate and compare
those trends. Analogous to the \code{\link{emmeans}} setting, we construct a
reference grid of these predicted trends, and then possibly average them over
some of the predictors in the grid.
}
\section{Generalizations}{

Instead of a single predictor, the user may specify some monotone function of
one variable, e.g., \code{var = "log(dose)"}. If so, the chain rule is
applied. Note that, in this example, if \code{model} contains
\code{log(dose)} as a predictor, we will be comparing the slopes estimated by
that model, whereas specifying \code{var = "dose"} would perform a
transformation of those slopes, making the predicted trends vary depending on
\code{dose}.
}

\examples{
fiber.lm <- lm(strength ~ diameter*machine, data=fiber)
# Obtain slopes for each machine ...
( fiber.emt <- emtrends(fiber.lm, "machine", var = "diameter") )
# ... and pairwise comparisons thereof
pairs(fiber.emt)

# Suppose we want trends relative to sqrt(diameter)...
emtrends(fiber.lm, ~ machine | diameter, var = "sqrt(diameter)", 
         at = list(diameter = c(20, 30)))

}
\seealso{
\code{link{emmeans}}, \code{\link{ref_grid}}
}
