% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_attributes.R
\name{layer_attribute_descriptions}
\alias{layer_attribute_descriptions}
\title{Variables available in a dataset (layer) from a data source (service).}
\usage{
layer_attribute_descriptions(
  wfs = NULL,
  service = NULL,
  service_version = NULL,
  layer
)
}
\arguments{
\item{wfs}{A \code{WFSClient} R6 object with methods for interfacing an
OGC Web Feature Service. From \code{\link[=emodnet_init_wfs_client]{emodnet_init_wfs_client()}}.}

\item{service}{the EMODnet OGC WFS service name.
For available services, see \code{\link[=emodnet_wfs]{emodnet_wfs()}}.}

\item{service_version}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
the WFS service version. Now always "2.0.0".}

\item{layer}{character sting of layer name. To get info on layers, including
\code{layer_name} use \code{\link[=emodnet_get_wfs_info]{emodnet_get_wfs_info()}}.}
}
\value{
data.frame containing layer attribute descriptions (metadata).
}
\description{
Get layer attribute description
}
\examples{
\dontshow{if (should_run_example()) withAutoprint(\{ # examplesIf}
layer_attribute_descriptions(
  service = "biology",
  layer = "mediseh_zostera_m_pnt"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Attributes metadata:
\code{\link{layer_attribute_inspect}()},
\code{\link{layer_attributes_get_names}()},
\code{\link{layer_attributes_summarise}()},
\code{\link{layer_attributes_tbl}()}
}
\concept{attributes}
