% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoji_fix.R
\name{emoji_fix}
\alias{emoji_fix}
\title{Turn emojis into qualified emojis}
\usage{
emoji_fix(x)
}
\arguments{
\item{x}{Characters, vector of emojis.}
}
\value{
vector of fully-qualified emojis
}
\description{
Some emojis can be written in multiple different ways either as
\code{fully-qualified}, \code{minimally-qualified}, or \code{unqualified}. \code{emoji_fix()}
will take any emoji and return the \code{fully-qualified} version of that emoji.
}
\details{
This function is vectorized.
}
\examples{
unqualified_ind <- which(emojis$qualified == "unqualified")[1:10]
unqualified <- emojis$emoji[unqualified_ind]

unqualified
emoji_fix(unqualified)
}
