% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-export_BPFCollection.R
\name{export_BPFCollection}
\alias{export_BPFCollection}
\title{Exports an emuDB into a BAS Partitur File (BPF) Collection}
\usage{
export_BPFCollection(handle, targetDir, extractLevels, refLevel = NULL,
  verbose = TRUE, newLevels = NULL, newLevelClasses = NULL,
  copyAudio = FALSE)
}
\arguments{
\item{handle}{handle to the emuDB}

\item{targetDir}{directory where the BPF collection should be saved}

\item{extractLevels}{list containing the names of labels (not levels!) that should be extracted, and their
matching BPF keys, e.g. extractLevels = list(SampleRate="SAM", Text="ORT", Phonemes="SAP")}

\item{refLevel}{optional name of level (not label!) used as reference for symbolic links. If NULL (the default), a link-less BPF collection is created.}

\item{verbose}{display infos, warnings and show progress bar}

\item{newLevels}{optional vector containing names of levels in the BPF collection that are not part of the standard 
BPF levels. See \url{http://www.bas.uni-muenchen.de/forschung/Bas/BasFormatseng.html#Partitur_tiersdef} for details on 
standard BPF levels.}

\item{newLevelClasses}{optional vector containing the classes of levels in the newLevels vector as integers. 
Must have the same length and order as newLevels.}

\item{copyAudio}{if true, audio files are copied to the new BPF collection}
}
\description{
This function exports an emuDB into the BAS Partitur File format, with one BPF file per bundle.
The user must pass a list of matching label names and BPF keys. 
\strong{Important:} The BPF format does not support explicit hierarchies with more than three
levels. Hence, you will probably lose information when exporting complex hierarchies.
}
\seealso{
export_TextGridCollection
}
