% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.ns.R
\name{get.ns}
\alias{get.ns}
\title{Quick Calculation of a Range of Network Statistics.}
\usage{
get.ns(x, balance.override = FALSE)
}
\arguments{
\item{x}{A network object.}

\item{balance.override}{Turns off balancing and balance checking.}
}
\value{
Returns the network statistics (ns) of all of the major ENA
functions: enaStructure, enaFlow, enaAscendency, enaStorage and enaUtility
(both flow and storage).
}
\description{
This is a high level function for calculated the main network
analyses (Ascendancy, Flow, Structure, Storage and Utility) on an
ecological network.
}
\examples{



data(troModels)
get.ns(troModels[[6]])


}
\references{
Fath, B. D., Borrett, S. R. 2006. A Matlab function for
Network Environ Analysis.  Environ. Model. Softw. 21, 375-405.
}
\seealso{
\code{\link{enaStructure}},\code{\link{enaFlow}},\code{\link{enaAscendency}},\code{\link{enaUtility}}
}
\author{
Matthew K. Lau Stuart R. Borrett David E. Hines
}
