edist <- 
function(x, sizes, distance = FALSE, ix = 1:sum(sizes)) {
    #  computes the e-dissimilarity matrix between k samples or clusters
    #  x:          pooled sample or distances
    #  sizes:      vector of sample (cluster) sizes
    #  distance:   TRUE if x is a distance matrix, otherwise FALSE
    #  ix:         a permutation of row indices of x 
    #    
    k <- length(sizes)
    if (k == 1) return (as.dist(0.0))
    if (k < 1) return (NA)
    e <- matrix(nrow=k, ncol=k)
    n <- cumsum(sizes)
    m <- 1 + c(0, n[1:(k-1)])
    if (distance == FALSE) {
        if (is.vector(x)) x <- matrix(x, nrow = length(x), ncol = 1)
        dst <- as.matrix(dist(x))
        }
    else dst <- as.matrix(x)
    for (i in 1:(k - 1)) {
        e[i, i] <- 0.0
        for (j in (i + 1):k) {
            n1 <- sizes[i]
            n2 <- sizes[j]
            ii <- ix[m[i]:n[i]]
            jj <- ix[m[j]:n[j]]
            w <- n1 * n2 / (n1 + n2)
            m11 <- sum(dst[ii, ii]) / (n1 * n1)
            m22 <- sum(dst[jj, jj]) / (n2 * n2)
            m12 <- sum(dst[ii, jj]) / (n1 * n2)
            e[i, j] <- e[j, i] <- w * ((m12 + m12) - (m11 + m22))
            }
        }
    as.dist(e)
}


energy.hclust <- 
function(dst) {
    d <- dst
    if (is.matrix(dst)) {
        if (nrow(dst) != ncol(dst) || sum(dst != t(dst)) > 0)
            stop("distance matrix must be square symmetric")
    	d <- as.dist(dst)
    	attr(d, "Labels") <- row.names(dst)
    }
    n <- attr(d, "Size")
    if (is.null(n))
        stop("dst argument must be square matrix or dist object")
    labels <- attr(d, "Labels")
    if (is.null(labels))
        labels <- paste(1:n)  
    merge <- integer(2 * (n - 1))
    height <- double(n - 1)
    order <- integer(n) 
    ecl <- .C("Emin_hclust", 
              diss = as.double(d), 
              en = as.integer(n), 
              merge = as.integer(merge), 
              height = as.double(height),
              order = as.integer(order),
              PACKAGE = "energy")
    merge <- matrix(ecl$merge, nrow = n - 1, ncol = 2)
    e <- list(merge = merge, 
              height = ecl$height, 
              order = ecl$order,
              labels = labels,
              method = "e-distance",
              call = match.call(),
              dist.method = attr(dst, "method"))      
    class(e) <- "hclust"            
    e
}
