% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enpls.fs.R
\name{enpls.fs}
\alias{enpls.fs}
\title{Ensemble Partial Least Squares for Feature Selection}
\usage{
enpls.fs(x, y, maxcomp = NULL, MCtimes = 500L, method = c("mc",
  "bootstrap"), ratio = 0.8, parallel = 1L)
}
\arguments{
\item{x}{predictor matrix}

\item{y}{response vector}

\item{maxcomp}{Maximum number of components included within the models, 
if not specified, default is the variable (column) numbers in x.}

\item{MCtimes}{times of Monte-Carlo}

\item{method}{\code{"mc"} or \code{"bootstrap"}. Default is \code{"mc"}.}

\item{ratio}{sample ratio used when \code{method = "mc"}}

\item{parallel}{Integer. Number of parallel processes to use. 
Default is \code{1}, which means run serially.}
}
\value{
A list containing two components:
\itemize{
\item \code{variable.importance} - a vector of variable importance
\item \code{coefficient.matrix} - original coefficient matrix
}
}
\description{
This function performs feature selection with ensemble partial least squares.
}
\details{
This function performs feature selection with ensemble partial least squares.
}
\examples{
data(alkanes)
x = alkanes$x
y = alkanes$y

set.seed(42)
varimp = enpls.fs(x, y, MCtimes = 100)
print(varimp)
plot(varimp)
}
\author{
Nan Xiao <\email{road2stat@gmail.com}>
}
\references{
Dongsheng Cao, Yizeng Liang, Qingsong Xu, Yifeng Yun, and Hongdong Li. 
"Toward better QSAR/QSPR modeling: simultaneous outlier detection and 
variable selection using distribution of model features." 
\emph{Journal of computer-aided molecular design} 25, no. 1 (2011): 67--80.
}
\seealso{
See \code{\link{enpls.od}} for outlier detection with ensemble PLS. 
See \code{\link{enpls.en}} for ensemble PLS regression.
}

