% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ensemble.R
\name{plot_ensemble}
\alias{plot_ensemble}
\title{Draws a plot for model predictions of ensembles of models. For classification the plot is a heatmap, for regression, scatterplot.}
\usage{
plot_ensemble(
  truth,
  tibble_pred,
  incorrect = FALSE,
  tibble_prob = NULL,
  order = NULL,
  facet = FALSE
)
}
\arguments{
\item{truth}{The \code{y} variable. In regression this is \code{numeric} vector, in classification this is a \code{factor} vector.}

\item{tibble_pred}{A \code{data.frame} of predictions. Each column corresponds to a candidate model.}

\item{incorrect}{If \code{TRUE}, for observations that were correctly classified by all models, remove all but a single observation per class. Classification only.}

\item{tibble_prob}{If not \code{NULL}, a \code{data.frame} with same column names as \code{tibble_pred}. Applies transparency based on the predicted probability of the predicted class. Classification only.}

\item{order}{default ordering is by \code{accuracy} (classification) or \code{RMSE} (regression). Can submit any other ordering e.g. \code{AUC}, which should be a \code{data.frame} with same column names as \code{tibble_pred}.}

\item{facet}{whether to facet the plots by model (regression only).}
}
\value{
a ggplot
}
\description{
Draws a plot for model predictions of ensembles of models. For classification the plot is a heatmap, for regression, scatterplot.
}
\examples{
data(iris)
if (require("MASS")){
lda.model <- lda(Species~., data = iris)
lda.pred <- predict(lda.model)
}
if (require("ranger")){
ranger.model <- ranger(Species~., data = iris)
ranger.pred <- predict(ranger.model, iris)
}

library(ensModelVis)

plot_ensemble(iris$Species,
data.frame(LDA = lda.pred$class,
RF = ranger.pred$predictions))

plot_ensemble(iris$Species,
 data.frame(LDA = lda.pred$class,
  RF = ranger.pred$predictions),
  incorrect= TRUE)

if (require("ranger")){
ranger.model <- ranger(Species~., data = iris, probability = TRUE)
ranger.prob <- predict(ranger.model, iris)
}

plot_ensemble(iris$Species,
  data.frame(LDA = lda.pred$class,
   RF = ranger.pred$predictions),
   tibble_prob = data.frame(LDA = apply(lda.pred$posterior, 1, max),
   RF = apply(ranger.prob$predictions, 1, max)))
}
