% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_my_taxtab.R
\name{sort_my_taxtab}
\alias{sort_my_taxtab}
\title{Sorts taxonomy table by ASV-identifying columns.}
\usage{
sort_my_taxtab(tt, ranknames)
}
\arguments{
\item{tt}{A taxonomy table supplied as a dataframe (no factors)}

\item{ranknames}{A character vector of the names of columns of tt that
contain taxonomic assignments. tt is sorted by columns not included in
ranknames.}
}
\value{
a dataframe sorted by the columns specified in ranknames
}
\description{
Sorts taxonomy table by ASV-identifying columns.
}
\details{
A helper function for the ...2df family of pre-processing functions.
If multiple columns are available to sort, it uses the left-most column.
}
\examples{
data("bayes.sample")
data("rubric.sample")
bayes.pretty <- bayestax2df(bayes.sample, rubric = rubric.sample)
sort_my_taxtab(bayes.pretty,
ranknames = c("kingdom", "supergroup", "division", "class", "order",
"family", "genus", "species"))

}
\seealso{
bayestax2df, idtax2df
}
\author{
Dylan Catlett
}
