% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_select.R
\name{weight_select}
\alias{weight_select}
\alias{weight_select.calibration}
\alias{relerr}
\alias{relerr.calibration}
\title{Tools for weighted calibrations}
\usage{
weight_select(x, weights, ...)

\method{weight_select}{calibration}(x, weights = NULL, ...)

relerr(x)

\method{relerr}{calibration}(x)
}
\arguments{
\item{x}{an object of class '\code{\link{calibration}}'.}

\item{weights}{a list of weights to be added to the default weights to be
checked. These are \code{1/concentration^0.5}, \code{1/concentration^1},
\code{1/concentration^2}, \code{1/signal^0.5}, \code{1/signal^1}, and
\code{1/signal^2}.}

\item{\dots}{further arguments passed to \code{\link{calibration}()}.}
}
\value{
\code{weight_select()} produces a matrix with differently weighted
'\code{calibration}' models ordered by sum relative errors.
\code{relerr()} compares the nominal concentrations with those predicted by
the \code{\link{calibration}} model.
}
\description{
Selecting optimum model weights by comparing sum relative errors, this is
\code{relerr()}, of weighted \code{\link{calibration}()} models as
suggested by Almeida et al. (2002).
}
\details{
If calibration data is not homoscedastic, a weighted least squares linear
calibration model may be applied to counteract the influence of high
concentrations on the regression model. This, in turn, typically improves the
accuracy at the lower end of the calibration curve (Almeida et al., 2002).
\code{weight_select} uses sum relative errors (\code{relerr}) to
find the best weight as suggested by Almeida et al. (2002). Predefined
weights include \code{1/concentration^0.5}, \code{1/concentration^1},
\code{1/concentration^2}, \code{1/signal^0.5}, \code{1/signal^1}, and
\code{1/signal^2} (see \code{\link{calibration}()} for details).
}
\examples{
data(din32645)
din <- calibration(Area ~ Conc, data = din32645)

weight_select(din)

relerr(din)

}
\references{
Almeida, A.M.D., Castel-Branco, M.M., & Falcao, A.C. (2002). Linear
regression for calibration lines revisited: weighting schemes for
bioanalytical methods. \emph{Journal of Chromatography B}, \bold{774}(2),
215-222. \doi{10.1016/S1570-0232(02)00244-1}.
}
\seealso{
Other calibration: 
\code{\link{calibration}()},
\code{\link{din32645}},
\code{\link{icp}},
\code{\link{matrix_effect}()},
\code{\link{neitzel2003}},
\code{\link{phenolics}}
}
\author{
Julius Albert, Kilian Kenngott, Zacharias Steinmetz
}
\concept{calibration}
