% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from.R
\name{import_from}
\alias{import_from}
\title{import objects}
\usage{
import_from(
  x,
  ...,
  .into = parent.frame(),
  .parent = .GlobalEnv,
  .overwrite = if (interactive()) "warn" else "error",
  .chdir = FALSE,
  .recursive = FALSE,
  .pos = 2L
)
}
\arguments{
\item{x}{a bare symbol name of a package, a character vector of filepaths, an
environment (which could be a python module), or any object with \code{names}
and \code{[[} methods defined.}

\item{...}{objects to import from x into \code{.into}. if named, the name will be
the the new name after import. Alternatively, you can also supply the
wildcard string "*" or "**", along with some additional overrides. See
examples for details.}

\item{.into}{An \R environment, or something coercible to one by
\code{\link{as.environment}}, or a character string that is the name of a
(potentially new) attached environment. The default is the current frame.}

\item{.parent, .chdir, .recursive}{Only applicable if \code{x} is a character vector
of filepaths to R scripts, in which case these are passed on to \link{include}
(\code{chdir}, \code{recursive}) or \link{new.env}\code{(parent)}}

\item{.overwrite}{One of \code{"warn"}, \code{"error"} or \code{"ignore"}. Can also be a
boolean \code{TRUE} (same as \code{"ignore"}) or \code{FALSE} (same as \code{"error"}). What
should be done if the requested import operation would overwrite an
existing object.}

\item{.pos}{Only applicable if \code{.into} is a string that is the name of a new
environment that will be attached, in which case this will be the position
on new environment on the search path.}
}
\value{
the \R environment or object that \code{x} resolved to, invisibly.
}
\description{
This is inspired by the python idiom \verb{from module import object as new_name}.
}
\note{
If \code{x} is a package name, then no check is performed to ensure the
object being imported is an exported function. As such, \code{import_from()} can
be used to access package internal objects, though doing so is usually bad
practice.
}
\examples{
show_whats_imported <- function(...) {
  import_from(...)
  setdiff(names(environment()), "...")
}

## Importing from an R package
# import one object
show_whats_imported(envir, include)

# rename an object on import
show_whats_imported(envir, sys_source = include)

# import all NAMESPACE exports
show_whats_imported(envir, "*")
show_whats_imported(envir) # missing `...` is interpreted as "*"

# import all NAMESPACE exports, except for `include`
show_whats_imported(envir, "*", -include)

# import all NAMESPACE exports, except rename `include` to `sys_source`
show_whats_imported(envir, "*", sys_source = include)

# exclude more than one
show_whats_imported(envir, "*", -include, -attach_eval)
show_whats_imported(envir, "*", -c(include, attach_eval))

# import all NAMESPACE exports, also one internal function names `find_r_files`
show_whats_imported(envir, "*", find_r_files)

# import ALL package functions, including all internal functions
show_whats_imported(envir, "**")

# import ALL objects in the package NAMESPACE, including R's NAMESPACE machinery
show_whats_imported(envir, "***")


## Importing from R files
# setup
dir.create(tmpdir <- tempfile())
owd <- setwd(tmpdir)
writeLines(c("useful_function <- function() 'I am useful'",
             ".less_useful_fn <- function() 'less useful'"),
           "my_helpers.R")

# import one function by name
show_whats_imported("my_helpers.R", useful_function)

# import all objects whose names don't start with a "." or "_"
show_whats_imported("my_helpers.R", "*")

# import all objects
show_whats_imported("my_helpers.R", "**")

# if the filepath to your scripts is stored in a variable, supply it in a call
x <- "my_helpers.R"
try(show_whats_imported(x)) # errors out, because no package 'x'
# to force the value to be used, just supply it as a call rather than a bare symbol.
# the simplest call can be just wrapping in () or {}
show_whats_imported({x})
show_whats_imported((x))
show_whats_imported(c(x))
show_whats_imported({{x}}) # tidyverse style unquoting

## Importing R objects

# if you have an actual R object that you want to import from, you will
# have to supply it in a call
x <- list(obj1 = "one", obj2 = "two")
show_whats_imported({x})

\dontrun{
  # don't run this so we don't take a reticulate dependency
  import_from(reticulate, py_module = import) # rename object on import

  # import one object
  show_whats_imported(py_module("numpy"), random)

  # to prevent automatic conversion
  show_whats_imported(py_module("numpy", convert = FALSE), random)

  # import all objects that don't begin with a `_`
  # by default, other modules found in the module are also not imported
  show_whats_imported(py_module("glob"), "*")

  # to import EVERYTHING pass "**"
  # now includes modules that your modules imported, like `os`
  show_whats_imported(py_module("glob"), "**")

  rm(py_module) # clean up
}

# cleanup
setwd(owd)
unlink(tmpdir, recursive = TRUE)
rm(show_whats_imported, tmpdir, owd)
}
