% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{mc.test}
\alias{mc.test}
\title{Robust medcouple MC-LR test - Only intended for developer use}
\usage{
mc.test(x, alpha = 0.05)
}
\arguments{
\item{x}{a numeric vector of data values.}

\item{alpha}{numeric value giving test significance level.}
}
\value{
A list is returned with elements:
\item{test.stat}{a numeric value giving the value of test statistics}
\item{crit numeric}{a vector of critical values defining rejection region of the test}
}
\description{
Performs robust medcouple test to evaluate the fit of the data to normal distribution.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function performs robust medcouple test based on the left and right medcouple (LMC and LRC).
The function is exported for developer use only. It does not perform any checks on inputs since it is only a convenience function for robust testing of the normality.
}
\references{
Brys G, Hubert M, Struyf A (2008). Goodness-of-fit tests based on a robust measure of skewness. Computational Statistics, 23(3), 429–442.

Todorov V, Filzmoser P (2009). An Object-Oriented Framework for Robust Multivariate Analysis. Journal of Statistical Software, 32(3), 1-47. URL http://www.jstatsoft.org/v32/i03/.
}
