% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FinancialNewsAPI.R
\name{financial_news}
\alias{financial_news}
\title{Financial news}
\usage{
financial_news(
  api_token,
  s = NULL,
  t = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = NULL,
  offset = NULL
)
}
\arguments{
\item{api_token}{The API token for authentication.}

\item{s}{(required if t empty) - The ticker code to get news for.}

\item{t}{(required if s empty) - The tag to get news on a given topic.}

\item{from_date}{date from with format Y-m-d}

\item{to_date}{date from with format Y-m-d}

\item{limit}{The number of results should be returned with the query}

\item{offset}{The offset of the data.}
}
\value{
A list containing the financial news.
}
\description{
This function retrieves financial news data from the API.
}
\examples{
api_token <- "demo"
s <- "balance sheet"
t <- NULL
from_date <- "2017-09-10"
to_date <- "2017-09-12"
limit <- "50"
offset <- "100"
result <- financial_news(api_token, s, t, from_date, to_date, limit, offset)

}
