% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundamentals.R
\name{get_fundamentals}
\alias{get_fundamentals}
\title{Retrieves and parses fundamental and financial data from eodhd api}
\usage{
get_fundamentals(
  ticker = "AAPL",
  exchange = "US",
  cache_folder = get_default_cache(),
  check_quota = TRUE
)
}
\arguments{
\item{ticker}{A company ticker (e.g. AAPL). You can find all tickers for a particular exchange with \code{\link[=get_tickers]{get_tickers()}}.}

\item{exchange}{A exchange symbol (e.g. US). You can find all tickers for a particular exchange with \code{\link[=get_tickers]{get_tickers()}}. Be aware that, for US companies, the exchange symbols is simply "US"}

\item{cache_folder}{A local directory to store cache files. By default, all functions use a temporary path, meaning that the caching system
is session persistent (it will remove all files when you exit your R session). If you want a persistent caching system, simply point argument
cache_folder to a local directory in your filesystem. Be aware, however, that a persistent cache will not refresh your data for new api queries.}

\item{check_quota}{A flag (TRUE/FALSE) for whether to check the current quota status from the api. This option implies a small cost of execution
time. If you need speed, just set it to FALSE.}
}
\value{
a list with several fundamental information
}
\description{
This function will download raw data from the fundamental end point of eodhd \url{https://eodhd.com/financial-apis/stock-etfs-fundamental-data-feeds} and
return a list. The raw data includes:
\itemize{
\item General information for the company (code, ISIN, currency, ..)
\item Financial highlights
\item Valuation
\item Raw financial data (see \code{\link[=parse_financials]{parse_financials()}} for parsing this data)
\item and many more (see example for more details regarding the output)
}
}
\examples{
\dontrun{
set_token(get_demo_token())
l_out <- get_fundamentals(ticker = "AAPL", exchange = "US")
names(l_out)
}
}
