% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amr_raw_to_phyloseq.R
\name{amr_raw_to_phyloseq}
\alias{amr_raw_to_phyloseq}
\title{Raw AMR files plus metadata to phyloseq object}
\arguments{
\item{path.to.amr.files}{path to data of raw csv files from ARMA
CARD analysis}

\item{metdata}{data.table of metadata with "arma_filename" and "arma_barcode"
columns required}

\item{coveragenumber}{Minimum percentage of a gene that must be
covered. Range from 0 to 99, default = 80}

\item{keepSNP}{TRUE or FALSE: whether to keep AMR gene conferred by one SNP
change, default = FALSE}
}
\value{
phyloseq object for downstream analysis
}
\description{
given directory and metadata make phyloseq object
\pkg{\link{phyloseq}} package required.
}
\examples{
\dontrun{
amr_raw_to_phyloseq(path.to.amr.files = path/to/amr.count.table,
metadata = metadata, coveragenumber = 80, keepSNP = FALSE)
}
}
\seealso{
\pkg{\link{phyloseq}}
}
